/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.summoningrituals.altar;

import com.almostreliable.summoningrituals.altar.AltarEntity;
import com.almostreliable.summoningrituals.util.MathUtils;
import com.mojang.math.Vector3f;
import java.util.Random;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AltarBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    private static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Stream.of(Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), Block.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0), Block.m_49796_((double)2.0, (double)9.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get();

    public AltarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && player instanceof ServerPlayer) {
            BlockEntity blockEntity;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND && (blockEntity = level.m_7702_(pos)) instanceof AltarEntity) {
                AltarEntity altar = (AltarEntity)blockEntity;
                ItemStack result = altar.handleInteraction(serverPlayer, player.m_21120_(InteractionHand.MAIN_HAND));
                return ItemStack.m_41728_((ItemStack)result, (ItemStack)player.m_21120_(InteractionHand.MAIN_HAND)) ? InteractionResult.PASS : InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState nState, LevelAccessor level, BlockPos pos, BlockPos nPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, direction, nState, level, pos, nPos);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new AltarEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return (entityLevel, entityState, entityType, entity) -> {
            if (entity instanceof AltarEntity) {
                AltarEntity altar = (AltarEntity)entity;
                altar.tick();
            }
        };
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        Vector3f[][] particlePos = MathUtils.getHorizontalVectors(new Vector3f(3.5f, 1.5f, 9.5f), new Vector3f(9.5f, 3.5f, 12.5f), new Vector3f(11.5f, 4.5f, 10.5f));
        int x = pos.m_123341_();
        int y = pos.m_123342_() + 1;
        int z = pos.m_123343_();
        Vector3f[] vec = particlePos[((Direction)state.m_61143_((Property)FACING)).ordinal() - 2];
        Boolean active = (Boolean)state.m_61143_((Property)ACTIVE);
        for (int i = 0; i < 3; ++i) {
            if (active.booleanValue()) {
                this.renderCandleActive(level, x, y, z, vec[i]);
                continue;
            }
            this.renderCandleInactive(level, x, y, z, vec[i]);
        }
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState superState = super.m_5573_(context);
        BlockState state = superState == null ? this.m_49966_() : superState;
        return (BlockState)((BlockState)((BlockState)state.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_192917_((Fluid)Fluids.f_76193_)));
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && player instanceof ServerPlayer && (blockEntity = level.m_7702_(pos)) instanceof AltarEntity) {
            AltarEntity altar = (AltarEntity)blockEntity;
            altar.playerDestroy(player.m_7500_());
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{ACTIVE}).m_61104_(new Property[]{WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    private void renderCandleActive(Level level, int x, int y, int z, Vector3f vec) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_123746_, (double)((float)x + vec.m_122239_() / 16.0f), (double)((float)y + (vec.m_122260_() + 2.0f) / 16.0f), (double)((float)z + vec.m_122269_() / 16.0f), 0.0, 0.0, 0.0);
    }

    private void renderCandleInactive(Level level, int x, int y, int z, Vector3f vec) {
        level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, (double)((float)x + vec.m_122239_() / 16.0f), (double)((float)y + vec.m_122260_() / 16.0f), (double)((float)z + vec.m_122269_() / 16.0f), 0.0, 0.0, 0.0);
    }
}

